%%  Classe de These pour l'ENST construite au-dessus de thloria.

%%  Auteur: Bechir ZALILA (bechir.zalila@enst.fr)
%%  $Id: thenst.cls 919 2008-09-13 09:52:17Z zalila $

\NeedsTeXFormat{LaTeX2e}[1997/12/01]
\ProvidesClass{thenst}[2008/01/02 (B. ZALILA, ENST))]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{thloria}}
\ProcessOptions
\LoadClass[openright]{thloria}

%%  Personnalisation de la page de titre
\SetTLFont{ThesisFirstPageHead}%
          {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{10}{14}%
\SetTLFont{ThesisTitle}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{20}{30}%
\SetTLFont{ThesisKind}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{30}{30}%
\SetTLFont{ThesisPresentedThe}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{m}{n}{10.95}{13}%
\SetTLFont{ThesisInOrderToGet}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{m}{n}{10.95}{13}%
\SetTLFont{ThesisDiploma}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{14}{18}%
\SetTLFont{ThesisSpecialty}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{10.95}{13}%
\SetTLFont{ThesisPresentedBy}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{m}{n}{10.95}{13}%
\SetTLFont{ThesisAuthor}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{m}{n}{14}{18}%
\SetTLFont{ThesisJuryTitle}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{10.95}{13}%
\SetTLFont{ThesisJury}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{m}{n}{10.95}{13}%
\SetTLFont{ThesisFirstPageFoot}%
             {\TitlePageFontEncoding}{\TitlePageFontFamily}{bx}{n}{10}{14}%

\renewcommand{\@ThesisKind}{{\UseEntryFont{ThesisKind}Th\`ese}}

\renewcommand\@thesis@titlep@gebody{%
  %---------------------------------------------------
  \@ThesisFirstPageHead
  \vskip20mm plus2fil
  \begin{center}
    \@ThesisKind
    \vskip10mm
    \@ThesisTitle
    \vskip5mm plus2fil
    \@ThesisPresentedThe
    \vskip3mm plus1fil
    \@ThesisInOrderToGet
    \vskip5mm plus1fil
    \@ThesisDiploma
    \vskip3mm plus1fil
    \@ThesisPresentedBy
    \vskip3mm plus1fil
    \@ThesisAuthor
  \end{center}
  \vskip5mm plus2fil
  \hskip1cm\@ThesisJuryTitle
  \begin{center}
    \@ThesisJury
  \end{center}
  \vskip5mm
  \@ThesisFirstPageFoot
  %---------------------------------------------------
}%

\renewenvironment{ThesisAbstract}
    {\ifabstracts@even\@newevendoublepage\else\@newdoublepage\fi
     \edef\saved@ps{\current@ps}%
     \pagestyle{\abs@ps}
     \markboth{}{}
     \def\@abstr@ct@beginning##1##2{%
         \section*{\@title@lignment ##1}
         \@abstract@hook{##1}%
         \if@tocswitch
            \DontFrameThisInToc
            \if@classic@section
               \addcontentsline{toc}{tlstarchapter}{##1}
            \else
               \addcontentsline{toc}{spsection}{##1}
            \fi
         \fi
         \reset@numbertocswitch
         \reset@frame@switch
         \def\KeyWords####1{\par\bigskip\noindent\textbf{##2:} ####1\par}
         }
     \newenvironment{FrenchAbstract}
        {\@abstr@ct@beginning{R\'esum\'e}{Mots-cl\'es}}
        {\vglue1cm minus 8mm}
     \newenvironment{EnglishAbstract}
        {\@abstr@ct@beginning{Abstract}{Keywords}%
         \ifx\english\@undefined
             \bgroup\language=0\relax
         \else
             \begin{english}
         \fi
         \leavevmode\hbox to\parindent{}\ignorespaces % 22/7/1994
        }
        {\ifx\english\@undefined
             \egroup
         \else
             \end{english}
         \fi
         \vglue1cm minus 8mm
        }
     \@mkboth{}{}%
     \vglue.5cm
    }
    {\global\@tocswitchfalse
     \global\@classic@sectionfalse
     %\@newdoublepage
     \long\def\@empty@ps{empty}%
     \newpage
     \if@twoside
       \ifodd\c@page
       \else
          \hbox{}%
          \ifx\@empty@ps\abs@ps
          \else
             \@empty@ps@cmd
          \fi
          \newpage
          \if@twocolumn\hbox{}\newpage\fi
          \pagestyle{\saved@ps}%
       \fi
     \else
       \pagestyle{\saved@ps}%
     \fi
     %\addtocounter{page}{-2}%
    }

%%  Suppression de la phrase ``Mis en page avec la classe thloria'' de
%%  la page 2.
\nthks

%% En tête de la thèse ENST
\newcommand{\@ENSThe@d}{{\UseEntryFont{ThesisFirstPageHead}\noindent
    \centerline{\if@logos@enst@edite@
      {\setbox0=\hbox{$\raise2.5cm\hbox{\ENSTEDITELogos}$}%
        \ht0=\baselineskip\box0}\hfill
      \else
      \'Ecole Nationale Sup\'erieure des T\'el\'ecommunications%
      \fi}%
}}

%% Logos de l'ENST et de l'EDITE sur la même ligne
\newcommand\ENSTEDITELogos{%
  \vtop to0pt{\hbox{}\hbox to0pt{\includegraphics[width=2.8cm]{enst}
      \hskip 7.2cm % Distance entre les 2 logos
      \includegraphics[width=7.2cm]{edite}\hss}\vss} }

\newif\if@logos@enst@edite@
\newcommand\ShowLogosENSTEDITE{\@logos@true\@logos@enst@edite@true}
\@onlypreamble\ShowLogosENSTEDITE
\ShowLogosENSTEDITE

%%  Nouveau type de thèse
\newcommand\ThesisENST{\renewcommand{\@ThesisFirstPageHead}{\@ENSThe@d}%
  \renewcommand{\@ThesisFirstPageFoot}{}% TODO
  \ThesisDiploma{{\UseEntryFont{ThesisDiploma}%
      Doctorat de l'\'Ecole Nationale Sup\'erieure des 
      T\'el\'ecommunications\\[3mm]
      {\UseEntryFont{ThesisSpecialty}sp\'ecialit\'e~:
        {\bf Informatique et R\'eseaux}}}}}

%%  Nouvelle catégorie de Jury
\NewJuryCategory{Directeurs}{\it Directeur de th\`ese :}
                            {\it Directeurs de th\`ese :}

%%  Entêtes et pieds de pages personnalisés
\newcommand\ps@ENSTHeadingsI{%
  \ifx\thesiscopyrightholder\undefined\def\thesiscopyrightholder{TELECOM~ParisTech}\fi
  \ifx\thesiscopyrightyear\undefined\def\thesiscopyrightyear{2008}\fi
  \def\thesiscopyrightnotice{{\tiny\textcopyright~\thesiscopyrightyear~\thesiscopyrightholder}}
  \def\@oddfoot{\thesiscopyrightnotice\hfil\thepage}%
  \def\@evenfoot{\thepage\hfil\thesiscopyrightnotice}%
  \def\@evenhead{\@gener@lhe@d{\leftmark}%
    {{\slshape\leftmark}\hfil}}%
  \def\@oddhead{\@gener@lhe@d{\leftmark\rightmark}%
    {\hfil\slshape\rightmark}}%
  \let\@mkboth\markboth
  \let\chaptermark\@chaptermark
  \let\sectionmark\@sectionmark
}

%% END
\endinput

%%% Local Variables:
%%% mode: latex
%%% mode: flyspell
%%% ispell-dictionary: "fr"
%%% End:
